%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

%    Sphere with a uniform volume charge

clear all;
close all;

EPS0 = 8.8542*10^(-12);
a = 1;
rho0 = 1*10^(-9);
r1 = 0:0.001*a:a;
r2 = a:0.005*a:10*a;
r = [r1 r2];

rho = [rho0*ones(1,length(r1)) zeros(1,length(r2))];
Ein = rho0*r1./(3*EPS0);
Eout = (rho0*a^3/3/EPS0)./r2.^2;
E = [Ein Eout];
figure(1);
plot(r,rho,'r');
xlabel('r/a');
ylabel('\rho [C/m^3)');
figure(2);
plot(r,E);
ylabel('E [V/m]');
xlabel('r/a');

